<?php

require_once "../../../controladores/contratos.controlador.php";
require_once "../../../modelos/contratos.modelo.php";

require_once "../../../controladores/personas.controlador.php";
require_once "../../../modelos/personas.modelo.php";

require_once "../../../controladores/usuarios.controlador.php";
require_once "../../../modelos/usuarios.modelo.php";

require_once "../../../controladores/plantilla.controlador.php";
require_once "../../../modelos/configuracion.modelo.php";

// require_once "../../../controladores/productos.controlador.php";
// require_once "../../../modelos/productos.modelo.php";

class imprimirEstadoCuenta{

public $idservicios;

public function traerImpresionEstadoCuenta(){

	date_default_timezone_set("America/Lima");
setlocale(LC_ALL, 'spanish');


$plantilla = new ControladorPlantilla();
$configuracion = $plantilla -> ctrConfiguracion()[0];
$logo = $configuracion['logo'];
$razon_social = $configuracion['razon_social'];
$prefijo =  $configuracion['prefijo'];
$celular =  $configuracion['celular'];
$email =  $configuracion['email'];
$direccion =  $configuracion['direccion'];
$nombreEmpresa = "$razon_social <br>Celular: $prefijo $celular <br> Correo: $email <br> Dirección: $direccion";
//TRAEMOS LA INFORMACIÓN DE LA VENTA

$itemContrata = "idservicios";
$valorContrata = $this->idservicios;

//Se agrego la funcion en Controlador Contratos Y Modelo Contratos

$respuestaContrata = ControladorContratos::ctrMostrarContratosReporte($itemContrata, $valorContrata);
$respuestaContrato = ControladorContratos::ctrMostrarContratos($itemContrata, $valorContrata);

//Modificacion de $respuestaContrata agregandole el arreglo [0]

$fecha = substr($respuestaContrata[0]["fecha_contrato"],0,-8);
$codigo = $respuestaContrata[0]["codigo"];
$valordiplomado = array_sum(array_column($respuestaContrata, 'monto'));
$restantediplomado = array_reduce($respuestaContrata, function($sum, $item) {
    return $sum + (($item['estado_pago'] == 0 || $item['estado_pago'] == 2) ? $item['monto'] : 0);
}, 0);


$fechaActual = date("Y-m-d H:i:s");
$estado = "";

if($respuestaContrata[0]["estado"]==0){
	$estado = "Activo";
}else if($respuestaContrata[0]["estado"] == 1){
	$estado = "Suspendido";
}else if($respuestaContrata[0]["estado"] == 2){
	$estado = "Finalizado";
}


//TRAEMOS LA INFORMACIÓN DEL CLIENTE

$itemCliente = "idpersona";
$valorCliente = $respuestaContrata[0]["idpersona"];

$respuestaCliente = ControladorPersonas::ctrMostrarPersonas($itemCliente, $valorCliente);

//TRAEMOS LA INFORMACIÓN DEL VENDEDOR

$itemUsuario = "id";
$valorUsuario = $respuestaContrata[0]["idusuario"];

$respuestaUsuario = ControladorUsuarios::ctrMostrarUsuarios($itemUsuario, $valorUsuario);

//REQUERIMOS LA CLASE TCPDF

require_once('tcpdf_include.php');

$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

$pdf->startPageGroup();

$pdf->AddPage();

// ---------------------------------------------------------

$bloque1 = <<<EOF

	<table>
		
	<tr>
			
	<td style="width:200px">
	<div>
	<br>
	<img src="../../../$logo" style="width: 140px;">
	</div>
	</td>

	<td style="width:200px">
		
		<div style="font-size:12px; line-height:15px; text-align:center">
			<br><br>
		$nombreEmpresa

		</div>

	</td>

	

	<td style="width:200px; text-align:center; color:red">
		<br><br><br>FOLIO N°.
		<br>$codigo</td>

</tr>

	</table>

EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ---------------------------------------------------------

$bloque2 = <<<EOF

	<table>
		
		<tr>
			
			<td style="width:540px"><img src="images/back.jpg"></td>
		
		</tr>

	</table>

	<table style="font-size:10px; padding:5px 10px;">
	
		<tr>
		
			<td style="border: 1px solid #666; background-color:white; width:390px">

				<b>Alumno:</b> $respuestaCliente[nombres]

			</td>

			<td style="border: 1px solid #666; background-color:white; width:150px; text-align:right">
			
				<b>Fecha:</b> $fecha

			</td>

		</tr>

		<tr>
		
			<td style="border: 1px solid #666; background-color:white; width:390px"><b>DIPLOMADO:</b> $respuestaCliente[direccion] - $respuestaCliente[nombre_zona]</td>


			<td style="border: 1px solid #666; background-color:white; width:150px; text-align:right">
			
				<b>ESTATUS:</b> $estado

			</td>

		</tr>

		<tr>
		
		<td style="border-bottom: 1px solid #666; background-color:white; width:540px"></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque2, false, false, false, false, '');

// ---------------------------------------------------------

//se modificaron las columnas

$bloque3 = <<<EOF

	<table style="font-size:8px; padding:5px 10px;">

		<tr>

		<td style="border: 1px solid #666; background-color:white; width:30px; text-align:center"><b>No.</b></td>
		
		<td style="border: 1px solid #666; background-color:white; width:110px; text-align:center"><b>Descripcion de pago</b></td>
		
		<td style="border: 1px solid #666; background-color:white; width:60px; text-align:center"><b>banco</b></td>

		<td style="border: 1px solid #666; background-color:white; width:60px; text-align:center"><b>Metodo de pago</b></td>
		<td style="border: 1px solid #666; background-color:white; width:60px; text-align:center"><b>Referencia</b></td>

		<td style="border: 1px solid #666; background-color:white; width:65px; text-align:center"><b>fecha acordada</b></td>

		<td style="border: 1px solid #666; background-color:white; width:75px; text-align:center"><b>Estado</b></td>

		<td style="border: 1px solid #666; background-color:white; width:75px; text-align:center"><b>Valor</b></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');

// -------------------------------------------------

// Aqui  hace el ciclo para agregar las filas 
$total = 0;

foreach ($respuestaContrata as $key => $value) {

	$cont = $key + 1;

	$fecha = strtotime($value["fechas_pagos"]);

	$mes = date("d/m/Y", $fecha);

	$estadoPago = "";
	
	$valor = number_format($value["monto"],2,'.',',');

	if($value["estado_pago"] == 0){
		$estadoPago = "PENDIENTE";
		$valor = "---------";
	}else if($value["estado_pago"] == 1){
		$estadoPago = "PAGADO";
		$total += $value["monto"];
	}else if ($value["estado_pago"] == 2){
		$estadoPago = "VENCIDO";
		$valor = "00.00";
	}else if ($value["estado_pago"] == 4){
		$estadoPago = "BAJA";
		$valor = "00.00";
	}

$bloque4 = <<<EOF

 	<table style="font-size:6px; padding:5px 10px;">

 		<tr>
 			<td style="border: 1px solid #666; color:#333; background-color:white; width:30px; text-align:center"><b>
 				$cont</b>
 			</td>
			
 			<td style="border: 1px solid #666; color:#333; background-color:white; width:110px; text-align:center">
 				$value[nombre_servicio]
 			</td>
 			<td style="border: 1px solid #666; color:#333; background-color:white; width:60px; text-align:center">
 				$value[banco]
 			</td>

 			<td style="border: 1px solid #666; color:#333; background-color:white; width:60px; text-align:center">
 				$value[metodopago]
 			</td>
 			
 			<td style="border: 1px solid #666; color:#333; background-color:white; width:60px; text-align:center">
 				$value[referancia]
 			</td>

 			<td style="border: 1px solid #666; color:#333; background-color:white; width:65px; xt-align:center; text-transform:capitalize;">
 				$mes
 			</td>

 			<td style="border: 1px solid #666; color:#333; background-color:white; width:75px; text-align:center"> 
 				$estadoPago
 			</td>

 			<td style="border: 1px solid #666; color:#333; background-color:white; width:75px; text-align:center">$valor 
 			</td>


 		</tr>

 	</table>


EOF;

	$pdf->writeHTML($bloque4, false, false, false, false, '');

}


$total = number_format($total,2,'.',',');
$valordiplomado = number_format($valordiplomado, 2,'.',',');
$restantediplomado = number_format($restantediplomado, 2,'.',',');

$bloque5 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">

		<tr>
        
		<td style="border: 1px solid #666; background-color:green; width:455px; text-align:right"><b>INVERSION CUBIERTA</b></td>

		<td style="border: 1px solid #666; background-color:white; width:80px; text-align:center"><b>$ $total</b></td>

		</tr>

	</table>

    
    <table style="font-size:9px; padding:5px 10px;">

		<tr>
        
		<td style="border: 1px solid #666; background-color:yellow; width:455px; text-align:right"><b>INVERSION PENDIENTE</b></td>

		<td style="border: 1px solid #666; background-color:white; width:80px; text-align:center"><b>$ $restantediplomado</b></td>

		</tr>

	</table>
    
	<table style="font-size:9px; padding:5px 10px;">

		<tr>
        
		<td style="border: 1px solid #666; background-color:orange; width:455px; text-align:right"><b>INVERSION TOTAL</b></td>

		<td style="border: 1px solid #666; background-color:white; width:80px; text-align:center"><b>$ $valordiplomado</b></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque5, false, false, false, false, '');

$clausula_contrato = $respuestaContrato['clausula_contrato'];
$equipos_asignados = $respuestaContrato['equipos_asignados'];
$bloque6 = <<<EOF

 	<table style="font-size:10px; padding:5px 10px;">
		<tr>	
			<td style="border:none; background-color:white; width:540px"></td>
		</tr>

 		<tr>
 			<td style="border: 1px solid #666; color:#333; background-color:white; text-align: justyfy;"> 
			 <b><br>
			 ACUERDOS CON EL ALUMNO:</b> $clausula_contrato
 			</td>
 		</tr>

		<tr>	
			<td style="border:none; background-color:white; width:540px"></td>
		</tr>

		<tr>
 			<td style="border: 1px solid #666; color:#333; background-color:white;"><b>
			 <br>
			ASESOR QUE LO INSCRIBIO:</b> $equipos_asignados
 			</td>
 		</tr>

 	</table>


EOF;

	$pdf->writeHTML($bloque6, false, false, false, false, '');


$bloque7 = <<<EOF

	<table style="font-size:9px; padding:5px 10px;">
		<tr>
		
		<td style="border:none; background-color:white; width:540px"></td>

		</tr>

		<tr>
		
		<td style="border:none; background-color:white; width:175px; text-align:center"><b>Elaborado por:</b> $respuestaUsuario[nombre]</td>

		</tr>
		<tr>

		<td style="border:none; background-color:white; width:175px; text-align:center"><b>Fecha:</b> $fechaActual</td>

		<td style="border:none; background-color:white; width:90px; text-align:center"><b></b></td>

		

		<td style="border:none; background-color:white; width:90px; text-align:center"><b></b></td>

		<td style="border:none; background-color:white; width:90px; text-align:center"><b></b></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque7, false, false, false, false, '');





//SALIDA DEL ARCHIVO 

//$pdf->Output('factura.pdf', 'D');
$pdf->Output('Estado_Cuenta.pdf');

}

}

$factura = new imprimirEstadoCuenta();
$factura -> idservicios = $_GET["idservicios"];
$factura -> traerImpresionEstadoCuenta();

?>